﻿
using System;
using System.Collections.Generic;
using System.Text;

namespace PI.ZB.N1200.ELearning.BL.DBD.View
{
    internal class StatisticCompetencePart : PI.FM.N000.Base.BL.DBD.BaseTable<BO.View.StatisticCompetencePart>
    {
        #region Static factory
        private static StatisticCompetencePart _factory = null;

        public static StatisticCompetencePart DBD
        {
            get
            {
                if (_factory == null)
                {
                    _factory = new StatisticCompetencePart();
                }
                return _factory;
            }
        }
        #endregion

        #region Override - Initialization
        protected override void InitializeTableName()
        {
            _tableName = "PIZB1200_CompetencePartStatisticView";
        }

        protected override void InitializeProperties()
        {
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("Name", "Name", true));
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("Abbreviation", "Abbreviation"));

            Add(new PI.FM.N000.Base.BL.DBD.LongProperty("CompetenceID", "CompetenceID"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("CompetencePoints", "CompetencePoints"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("CompetencePointsByWeight", "CompetencePointsByWeight"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("CompetenceMaxPoints", "CompetenceMaxPoints"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("CaseStudyPoints", "CaseStudyPoints"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("CaseStudyMaxPoints", "CaseStudyMaxPoints"));
            Add(new PI.FM.N000.Base.BL.DBD.DecimalProperty("Salary", "Salary"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("ResetCount", "ResetCount"));
        }
        #endregion


        #region Commands definition
        public enum Commands
        {
            RestoreBySearch = 10,
        }
        #endregion

        #region Get Commands
        protected override Gemini.Core.BL.Interface.DBD.ICommand DoGetCommand(int CommandID)
        {
            switch (CommandID)
            {
                case (int)Commands.RestoreBySearch: return new Command_RestoreBySearch();
            }

            return base.DoGetCommand(CommandID);
        }
        #endregion

        #region Additional Commands Classes
        class Command_RestoreBySearch : PI.FM.N000.Base.BL.DBD.BaseCommand<BO.View.StatisticCompetencePart>
        {
            public Command_RestoreBySearch() : base(PI.ZB.N1200.ELearning.BL.DBD.View.StatisticCompetencePart.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

            protected override void InitializeParametrs()
            {
                Add(new Gemini.Core.BL.DBD.Param("ClassID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("StudentID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("CompetenceID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
            }

            protected override void InitializeCommandText()
            {
                _commandText = "PIZB1200_CompetencePartStatisticView_RestoreBySearch";
            }
        }
        #endregion
    }
}